#include <iostream>
#include <vector>
#include <queue>
#include <climits>

using namespace std;

struct Room {
    int strength;
    bool hasPlatform;
    vector<int> neighbors;
};

int main() {
    int N;
    cin >> N;

    vector<Room> rooms(N + 1);

    for (int i = 1; i < N; ++i) {
        int U, V;
        cin >> U >> V;
        rooms[U].neighbors.push_back(V);
        rooms[V].neighbors.push_back(U);
    }

    for (int i = 1; i <= N; ++i) {
        int platform;
        cin >> platform;
        rooms[i].hasPlatform = (platform == 1);
    }

    vector<int> changes(N + 1);

    for (int i = 1; i <= N; ++i) {
        cin >> changes[i];
    }

    vector<int> jumps(N + 1, INT_MAX);

    queue<int> q;
    q.push(1);
    jumps[1] = 0;

    while (!q.empty()) {
        int currentRoom = q.front();
        q.pop();

        for (int neighbor : rooms[currentRoom].neighbors) {
            if (jumps[neighbor] == INT_MAX) {
                q.push(neighbor);
                jumps[neighbor] = jumps[currentRoom] + 1;
            }
        }
    }

    for (int i = 1; i <= N; ++i) {
        int currentRoom = i;
        int requiredJumps = 0;

        while (currentRoom != 1 && requiredJumps <= jumps[i]) {
            if (changes[currentRoom] == 1) {
                if (!rooms[currentRoom].hasPlatform) {
                    requiredJumps = -1;
                    break;
                }
                ++requiredJumps;
            }

            currentRoom = rooms[currentRoom].neighbors[0];
        }

        cout << requiredJumps << " ";
    }

    cout << endl;

    return 0;
}